$(document).ready(function()
{
	user.show_main_view_intreface()
	user.show_errors_info()

	utils.load_script('network_settings.js')
	.then(() => utils.load_script('app_sw_control.js'))
	.then(() => utils.load_script('app_sw.js'))
	const device_info_script = utils.load_script('device_info.js')
	const network_settings_script = utils.load_script('network_settings.js')
	const app_sw_control_script = utils.load_script('app_sw_control.js')
    const app_sw_script = utils.load_script('app_sw.js')
	Promise.all([
		device_info_script,
		network_settings_script,
		app_sw_control_script,
		app_sw_script
	])
	.then(() => app_sw_control.main())
	.then(() => app_sw.main())
	.then(() => mcu_common.request_board_types())
	.then(text => common.response_ready(text))
	.then(values => async function(values) {
		await device_info.show()
		let product_code = values[0]
		let types = values.slice(1)
		let product_code_arr = utils.ip2array(product_code)

		//product_code_arr[0] = 11 // test EM-12T
		mcu_common.set_boards_count(product_code_arr)
		mcu_common.show_boards_types_setting()
		mcu_common.show_boards_by_type(types, product_code_arr)
		await network_settings.show(product_code_arr)

		user.on_page_loading_finished()
		user.load_page()
	}(values))
})
